package ru.yandex.travel.orders.workflows.payments.invoice.handlers;

import java.time.Instant;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.PendingInvoice;
import ru.yandex.travel.orders.workflow.order.proto.TInvoiceRefunded;
import ru.yandex.travel.orders.workflow.order.proto.TPaymentCanNotBeCancelled;
import ru.yandex.travel.orders.workflow.order.proto.TPaymentCancelled;
import ru.yandex.travel.orders.workflow.payments.proto.EPaymentState;
import ru.yandex.travel.orders.workflow.payments.proto.TCancelPayment;
import ru.yandex.travel.orders.workflow.payments.proto.TConfirmPayment;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;
import ru.yandex.travel.workflow.base.IgnoreEvents;

@IgnoreEvents(types = TConfirmPayment.class)
@Slf4j
public class FullyPaidStateHandler extends BasePendingInvoiceHandler {
    @HandleEvent
    public void handleInvoiceRefunded(TInvoiceRefunded message, StateContext<EPaymentState, PendingInvoice> ctx) {
        ctx.scheduleExternalEvent(ctx.getWorkflowEntity().getOwnerOrder().getWorkflow().getId(), message);
    }

    @HandleEvent
    public void handleCancelPayment(TCancelPayment message, StateContext<EPaymentState, PendingInvoice> ctx) {
        if (ctx.getWorkflowEntity().isZeroPayment()) {
            // we'll just mark it as cancelled, cause there must be no trust invoice, nothing to cancel
            ctx.setState(EPaymentState.PS_CANCELLED);
            ctx.getWorkflowEntity().setClosedAt(Instant.now());
            ctx.scheduleExternalEvent(ctx.getWorkflowEntity().getOwnerWorkflowId(),
                    TPaymentCancelled.newBuilder().build());
        } else if (message.getRefundIfAlreadyPaid()) {
            fullyRefundPaidAttempt(ctx);
            ctx.setState(EPaymentState.PS_CANCELLATION_IN_PROGRESS);
        } else {
            ctx.scheduleExternalEvent(ctx.getWorkflowEntity().getOwnerWorkflowId(),
                    TPaymentCanNotBeCancelled.newBuilder().build());
        }
    }
}
