package ru.yandex.travel.orders.workflows.payments.invoice.handlers;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.PendingInvoice;
import ru.yandex.travel.orders.workflow.order.proto.TMoneyAcquireErrorOccurred;
import ru.yandex.travel.orders.workflow.order.proto.TMoneyAcquired;
import ru.yandex.travel.orders.workflow.payments.proto.EPaymentState;
import ru.yandex.travel.orders.workflow.payments.proto.TCancelPayment;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
public class PaymentInProgressStateHandler extends BasePendingInvoiceHandler {

    @HandleEvent
    public void handleMoneyAcquire(TMoneyAcquired message, StateContext<EPaymentState, PendingInvoice> ctx) {
        log.info("Money acquired, invoice is paid: notifying the owner");
        finishPayment(ctx);
    }

    @HandleEvent
    public void handleMoneyAcquireError(TMoneyAcquireErrorOccurred message, StateContext<EPaymentState,
            PendingInvoice> context) {
        log.info("Money acquire error has occurred");
        context.setState(EPaymentState.PS_INVOICE_PENDING);
        if (context.getWorkflowEntity().getPaymentSchedule() != null) {
            context.scheduleExternalEvent(context.getWorkflowEntity().getPaymentSchedule().getWorkflow().getId(),
                    TMoneyAcquireErrorOccurred.newBuilder()
                            .setPaymentId(context.getWorkflowEntity().getId().toString())
                            .build());
        }
    }

    @HandleEvent
    public void handleCancelPayment(TCancelPayment message, StateContext<EPaymentState, PendingInvoice> ctx) {
        ctx.setState(EPaymentState.PS_CANCELLATION_IN_PROGRESS);
    }
}
