package ru.yandex.travel.orders.workflows.payments.jobs;

import java.time.Duration;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix = "payment-schedule.jobs", ignoreUnknownFields = false)
@Getter
@Setter
@Validated
public class PaymentJobsConfigurationProperties {
    @NotNull
    @Valid
    private TaskProcessorProperties refundExpiredSchedules;

    @NotNull
    @Valid
    private TaskProcessorProperties notifyExpiringSchedulesByEmail;

    @NotNull
    @Valid
    private TaskProcessorProperties notifyExpiringSchedulesByTicket;

    @NotNull
    @Valid
    private TaskProcessorProperties autoPaySchedules;


    @Getter
    @Setter
    @Validated
    public static class TaskProcessorProperties {
        @NotNull
        private boolean enabled;
        @NotNull
        private Duration initialStartDelay;
        @NotNull
        private Duration period;
        @Positive
        private int numberOfItems;
    }

}


