package ru.yandex.travel.orders.workflows.payments.schedule;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.PaymentSchedule;
import ru.yandex.travel.orders.services.finances.FinancialEventService;
import ru.yandex.travel.orders.services.payments.TrustClientProvider;
import ru.yandex.travel.orders.services.payments.schedule.HotelPaymentScheduleBuilderProperties;
import ru.yandex.travel.orders.workflow.payments.proto.EPaymentState;
import ru.yandex.travel.orders.workflows.payments.schedule.handlers.CancellationInProgressStateHandler;
import ru.yandex.travel.orders.workflows.payments.schedule.handlers.CancelledStateHandler;
import ru.yandex.travel.orders.workflows.payments.schedule.handlers.DraftStateHandler;
import ru.yandex.travel.orders.workflows.payments.schedule.handlers.FullyPaidStateHandler;
import ru.yandex.travel.orders.workflows.payments.schedule.handlers.InitialPaymentInProgressStateHandler;
import ru.yandex.travel.orders.workflows.payments.schedule.handlers.InvoicePendingStateHandler;
import ru.yandex.travel.orders.workflows.payments.schedule.handlers.PartiallyPaidStateHandler;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
@RequiredArgsConstructor
public class PaymentScheduleWorkflowConfiguration {

    private final EntityStateTransitionRepository entityStateTransitionRepository;
    private final TrustClientProvider trustClientProvider;
    private final HotelPaymentScheduleBuilderProperties scheduleBuilderProperties;
    private final FinancialEventService financialEventService;

    @Bean
    public WorkflowEventHandler<PaymentSchedule> paymentScheduleWorkflowEventHandler() {
        ImmutableMap.Builder<EPaymentState,
                StatefulWorkflowEventHandler<EPaymentState, PaymentSchedule>> builder = ImmutableMap.builder();
        builder.put(EPaymentState.PS_DRAFT, new DraftStateHandler())
                .put(EPaymentState.PS_INVOICE_PENDING, new InvoicePendingStateHandler())
                .put(EPaymentState.PS_PAYMENT_IN_PROGRESS,
                        new InitialPaymentInProgressStateHandler(trustClientProvider, scheduleBuilderProperties))
                .put(EPaymentState.PS_PARTIALLY_PAID, new PartiallyPaidStateHandler(trustClientProvider,
                        scheduleBuilderProperties, financialEventService))
                .put(EPaymentState.PS_CANCELLATION_IN_PROGRESS, new CancellationInProgressStateHandler())
                .put(EPaymentState.PS_CANCELLED, new CancelledStateHandler())
                .put(EPaymentState.PS_FULLY_PAID, new FullyPaidStateHandler());

        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
