package ru.yandex.travel.orders.workflows.payments.schedule.handlers;

import com.google.protobuf.Message;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.PaymentSchedule;
import ru.yandex.travel.orders.workflow.order.proto.TClearingInProcess;
import ru.yandex.travel.orders.workflow.order.proto.TInvoiceCleared;
import ru.yandex.travel.orders.workflow.order.proto.TInvoicePaymentStarted;
import ru.yandex.travel.orders.workflow.payments.proto.EPaymentState;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
public class BasePaymentScheduleHandler extends AnnotatedStatefulWorkflowEventHandler<EPaymentState, PaymentSchedule> {
    @HandleEvent
    public void handle(TInvoicePaymentStarted message, StateContext<EPaymentState, PaymentSchedule> ctx) {
        propagateMessageToOwner(message, ctx);
    }

    @HandleEvent
    public void handle(TClearingInProcess message, StateContext<EPaymentState, PaymentSchedule> ctx) {
        propagateMessageToOwner(message, ctx);
    }

    @HandleEvent
    public void handle(TInvoiceCleared message, StateContext<EPaymentState, PaymentSchedule> ctx) {
        propagateMessageToOwner(message, ctx);
    }

    protected void propagateMessageToOwner(Message message, StateContext<EPaymentState, PaymentSchedule> ctx) {
        log.info("Forwarding the event of class {} to owner workflow", message.getClass().getSimpleName());
        sendMessageToOwner(message, ctx);
    }

    protected void sendMessageToOwner(Message message, StateContext<EPaymentState, PaymentSchedule> ctx) {
        ctx.scheduleExternalEvent(ctx.getWorkflowEntity().getOwnerWorkflowId(), message);
    }
}
