package ru.yandex.travel.orders.workflows.payments.schedule.handlers;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.PaymentSchedule;
import ru.yandex.travel.orders.workflow.order.proto.TPaymentCanNotBeCancelled;
import ru.yandex.travel.orders.workflow.order.proto.TPaymentCancelled;
import ru.yandex.travel.orders.workflow.payments.proto.EPaymentState;
import ru.yandex.travel.orders.workflow.payments.proto.TCancelPayment;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;
import ru.yandex.travel.workflow.base.IgnoreEvents;

@Slf4j
@IgnoreEvents(types = TPaymentCancelled.class)
public class CancelledStateHandler extends BasePaymentScheduleHandler {

    @HandleEvent
    public void handlePaymentCanNotBeCancelled(TPaymentCanNotBeCancelled event,
                                               StateContext<EPaymentState, PaymentSchedule> ctx) {
        if (!ctx.getWorkflowEntity().getAllowPaidItemsWhenCancelling()) {
            throw new IllegalStateException("TPaymentCanNotBeCancelled encountered on cancellation " +
                    "when paid items should not be left");
        }
    }

    @HandleEvent
    public void handleCancelPayment(TCancelPayment event,
                                    StateContext<EPaymentState, PaymentSchedule> ctx) {
        log.info("Payment is already cancelled");
    }
}
