package ru.yandex.travel.orders.workflows.payments.schedule.handlers;

import ru.yandex.travel.orders.entities.PaymentSchedule;
import ru.yandex.travel.orders.workflow.payments.proto.EPaymentState;
import ru.yandex.travel.orders.workflow.payments.proto.TCancelPayment;
import ru.yandex.travel.orders.workflow.payments.proto.TPublish;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;

public class DraftStateHandler extends BasePaymentScheduleHandler {

    @HandleEvent
    public void handlePublish(TPublish message, StateContext<EPaymentState, PaymentSchedule> ctx) {
        ctx.setState(EPaymentState.PS_INVOICE_PENDING);
        ctx.scheduleExternalEvent(ctx.getWorkflowEntity().getInitialPendingInvoice().getWorkflow().getId(),
                TPublish.newBuilder().build());
    }

    @HandleEvent
    public void handleCancelPayment(TCancelPayment message, StateContext<EPaymentState, PaymentSchedule> ctx) {
        ctx.setState(EPaymentState.PS_CANCELLATION_IN_PROGRESS);
        ctx.scheduleExternalEvent(ctx.getWorkflowEntity().getInitialPendingInvoice().getWorkflow().getId(), message);
        ctx.getWorkflowEntity().setAllowPaidItemsWhenCancelling(!message.getRefundIfAlreadyPaid());
        ctx.getWorkflowEntity().getItems().forEach(i ->
                ctx.scheduleExternalEvent(i.getPendingInvoice().getWorkflow().getId(), message));
    }
}
