package ru.yandex.travel.orders.workflows.payments.schedule.handlers;

import ru.yandex.travel.orders.entities.PaymentSchedule;
import ru.yandex.travel.orders.workflow.order.proto.TMoneyAcquired;
import ru.yandex.travel.orders.workflow.order.proto.TPaymentCanNotBeCancelled;
import ru.yandex.travel.orders.workflow.payments.proto.EPaymentState;
import ru.yandex.travel.orders.workflow.payments.proto.TCancelPayment;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;
import ru.yandex.travel.workflow.base.IgnoreEvents;

@IgnoreEvents(types = {TMoneyAcquired.class})
public class FullyPaidStateHandler extends BasePaymentScheduleHandler {
    @HandleEvent
    public void handleCancelPayment(TCancelPayment message, StateContext<EPaymentState, PaymentSchedule> ctx) {
        ctx.scheduleExternalEvent(ctx.getWorkflowEntity().getOwnerWorkflowId(),
                TPaymentCanNotBeCancelled.newBuilder().build());
    }
}
