package ru.yandex.travel.orders.workflows.payments.schedule.handlers;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.PaymentSchedule;
import ru.yandex.travel.orders.workflow.payments.proto.EPaymentState;
import ru.yandex.travel.orders.workflow.payments.proto.TCancelPayment;
import ru.yandex.travel.orders.workflow.payments.proto.TStartPayment;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
public class InvoicePendingStateHandler extends BasePaymentScheduleHandler {

    @HandleEvent
    public void handleStartPayment(TStartPayment message, StateContext<EPaymentState, PaymentSchedule> ctx) {
            log.info("Starting payment of initial invoice");
            ctx.setState(EPaymentState.PS_PAYMENT_IN_PROGRESS);
            ctx.scheduleExternalEvent(ctx.getWorkflowEntity().getInitialPendingInvoice().getWorkflow().getId(),
                    message);
    }

    @HandleEvent
    public void handleCancelPayment(TCancelPayment message, StateContext<EPaymentState, PaymentSchedule> ctx) {
        ctx.setState(EPaymentState.PS_CANCELLATION_IN_PROGRESS);
        ctx.getWorkflowEntity().setAllowPaidItemsWhenCancelling(!message.getRefundIfAlreadyPaid());
        ctx.scheduleExternalEvent(ctx.getWorkflowEntity().getInitialPendingInvoice().getWorkflow().getId(), message);
        ctx.getWorkflowEntity().getItems().forEach(i ->
                ctx.scheduleExternalEvent(i.getPendingInvoice().getWorkflow().getId(), message));
    }
}
