package ru.yandex.travel.orders.workflows.plus.topup;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.task_processor.TaskProcessorProperties;

@ConfigurationProperties(value = "yandex-plus-promo", ignoreUnknownFields = false)
@Getter
@Setter
@Component
@Validated
public class YandexPlusPromoProperties {
    @NotNull
    private TaskProcessorProperties awaitPaymentProcessor;
    @NotNull
    private Duration awaitPaymentCheckPeriod;
    @NotNull
    private Duration topupDelay;
    @NotNull
    private ZoneId defaultHotelTimeZoneId;
    @NotNull
    private Instant minTopupAt;
    @NotNull
    private PayloadProperties payload;
    @NotNull
    private PayloadProperties toursPayload;
    @NotNull
    private Long billingClientId;

    private boolean toursEnabled = false; // should be removed when integration details are established and proper toursPayload is set in config

    @Data
    @Validated
    public static class PayloadProperties {
        @NotEmpty
        private String cashbackService;
        @NotEmpty
        private String issuer;
        @NotEmpty
        private String campaignName;
        @NotEmpty
        private String ticket;
        @NotEmpty
        private String country = "RU";
        @NotEmpty
        private String currency = "RUB";
    }
}
