package ru.yandex.travel.orders.workflows.plus.topup;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.YandexPlusTopup;
import ru.yandex.travel.orders.services.finances.FinancialEventService;
import ru.yandex.travel.orders.services.payments.TrustClientProvider;
import ru.yandex.travel.orders.workflow.plus.proto.EYandexPlusTopupState;
import ru.yandex.travel.orders.workflows.plus.topup.handlers.ClearedStateHandler;
import ru.yandex.travel.orders.workflows.plus.topup.handlers.NewStateHandler;
import ru.yandex.travel.orders.workflows.plus.topup.handlers.StartingPaymentStateHandler;
import ru.yandex.travel.orders.workflows.plus.topup.handlers.WaitingPaymentStateHandler;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
@RequiredArgsConstructor
public class YandexPlusTopupWorkflowConfiguration {
    private final EntityStateTransitionRepository entityStateTransitionRepository;
    private final TrustClientProvider trustClientProvider;
    private final YandexPlusPromoProperties yandexPlusPromoProperties;
    private final FinancialEventService financialEventService;

    private final NewStateHandler newStateHandler;

    @Bean
    public WorkflowEventHandler<?> yandexPlusTopupWorkflowEventHandler() {
        ImmutableMap.Builder<EYandexPlusTopupState, StatefulWorkflowEventHandler<EYandexPlusTopupState,
                YandexPlusTopup>> builder = ImmutableMap.builder();
        builder
                .put(EYandexPlusTopupState.PS_NEW, newStateHandler)
                .put(EYandexPlusTopupState.PS_STARTING_PAYMENT,
                        new StartingPaymentStateHandler(trustClientProvider, yandexPlusPromoProperties))
                .put(EYandexPlusTopupState.PS_WAIT_FOR_PAYMENT,
                        new WaitingPaymentStateHandler())
                .put(EYandexPlusTopupState.PS_CLEARED, new ClearedStateHandler(financialEventService));

        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
