package ru.yandex.travel.orders.workflows.plus.topup.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.commons.logging.NestedMdc;
import ru.yandex.travel.orders.entities.YandexPlusTopup;
import ru.yandex.travel.orders.services.finances.FinancialEventService;
import ru.yandex.travel.orders.workflow.plus.proto.EYandexPlusTopupState;
import ru.yandex.travel.orders.workflow.plus.proto.TStoreFinEvents;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
@RequiredArgsConstructor
public class ClearedStateHandler extends AnnotatedStatefulWorkflowEventHandler<EYandexPlusTopupState, YandexPlusTopup> {
    private final FinancialEventService financialEventService;

    @HandleEvent
    public void handleStoreFinEvents(TStoreFinEvents event, StateContext<EYandexPlusTopupState, YandexPlusTopup> ctx) {
        YandexPlusTopup topup = ctx.getWorkflowEntity();
        try (NestedMdc ignored = NestedMdc.forOptionalEntity(topup.getOrderItem())) {
            try {
                financialEventService.registerPlusPointsTopup(topup);
            } catch (Exception e) {
                log.warn("Failed to generate Yandex Plus topup financial event", e);
                throw e;
            }
        }
        ctx.setState(EYandexPlusTopupState.PS_FINANCIAL_EVENT_SENT);
    }
}
