package ru.yandex.travel.orders.workflows.plus.topup.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.YandexPlusTopup;
import ru.yandex.travel.orders.services.payments.TrustClient;
import ru.yandex.travel.orders.services.payments.TrustClientProvider;
import ru.yandex.travel.orders.services.payments.TrustUserInfo;
import ru.yandex.travel.orders.workflow.plus.proto.EYandexPlusTopupState;
import ru.yandex.travel.orders.workflow.plus.proto.TTopupStartPayment;
import ru.yandex.travel.orders.workflows.plus.topup.YandexPlusPromoProperties;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
@RequiredArgsConstructor
public class StartingPaymentStateHandler
        extends AnnotatedStatefulWorkflowEventHandler<EYandexPlusTopupState, YandexPlusTopup> {
    private final TrustClientProvider trustClientProvider;
    private final YandexPlusPromoProperties properties;

    @HandleEvent
    public void handleToPupStart(TTopupStartPayment event, StateContext<EYandexPlusTopupState, YandexPlusTopup> context) {
        YandexPlusTopup topup = context.getWorkflowEntity();
        TrustClient trustClient = trustClientProvider.getTrustClientForPaymentProfile(topup.getPaymentProfile());
        TrustUserInfo userInfo = new TrustUserInfo(topup.getPassportId(), topup.getUserIp());
        trustClient.startPayment(topup.getPurchaseToken(), userInfo);

        topup.setBackgroundJobActive(true);
        topup.rescheduleNextCheckStatusAt(properties.getAwaitPaymentCheckPeriod());
        context.setState(EYandexPlusTopupState.PS_WAIT_FOR_PAYMENT);
    }
}
