package ru.yandex.travel.orders.workflows.plus.topup.jobs;

import java.util.UUID;

import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.workflows.plus.topup.YandexPlusPromoProperties;
import ru.yandex.travel.spring.tx.ForcedRollbackTxManagerWrapper;
import ru.yandex.travel.task_processor.TaskProcessor;
import ru.yandex.travel.task_processor.TaskProcessorHelper;

@Configuration
@RequiredArgsConstructor
public class YandexPlusTopupTaskProcessorsConfiguration {

    private final YandexPlusTopupRefreshService yandexPlusTopupRefreshService;

    private final ForcedRollbackTxManagerWrapper forcedRollbackTxManagerWrapper;

    private final YandexPlusPromoProperties yandexPlusPromoProperties;

    @Bean
    public TaskProcessor<UUID> yandexPlusTopupAwaitingPaymentProcessor() {
        return TaskProcessorHelper.simpleTaskProcessor(yandexPlusTopupRefreshService, forcedRollbackTxManagerWrapper,
                yandexPlusPromoProperties.getAwaitPaymentProcessor());
    }
}
