package ru.yandex.travel.orders.workflows.supervisors.generic;

import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.management.StarTrekService;
import ru.yandex.travel.workflow.WorkflowEventHandler;

@Configuration
@RequiredArgsConstructor
public class GenericErrorSupervisorWorkflowConfiguration {
    private final StarTrekService starTrekService;

    @Bean
    public WorkflowEventHandler genericErrorSupervisorWorkflowEventHandler() {
        return new GenericErrorSupervisorWorkflowEventHandler(starTrekService);
    }
}
