package ru.yandex.travel.orders.workflows.supervisors.generic;

import java.util.UUID;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.WellKnownWorkflowEntityType;
import ru.yandex.travel.orders.management.StarTrekService;
import ru.yandex.travel.workflow.MessagingContext;
import ru.yandex.travel.workflow.TWorkflowCrashed;
import ru.yandex.travel.workflow.base.AnnotatedWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
@RequiredArgsConstructor
public class GenericErrorSupervisorWorkflowEventHandler extends AnnotatedWorkflowEventHandler<Void> {
    private final StarTrekService starTrekService;

    @HandleEvent
    public void handleWorkflowCrashedEvent(TWorkflowCrashed event, MessagingContext<Void> ctx) {
        String workflowId = event.getWorkflowId();
        try {
            String entityType = event.getEntityType();
            long eventId = event.getEventId();
            if (WellKnownWorkflowEntityType.VOUCHER.getDiscriminatorValue().equals(entityType)) {
                starTrekService.createIssueForPdfNotReceived(UUID.fromString(event.getEntityId()), eventId, ctx);
            } else if (WellKnownWorkflowEntityType.NOTIFICATION.getDiscriminatorValue().equals(entityType)) {
                starTrekService.createIssueForNotificationNotSent(UUID.fromString(event.getEntityId()), eventId, ctx);
            } else if (WellKnownWorkflowEntityType.PLUS_POINTS_TOPUP.getDiscriminatorValue().equals(entityType)) {
                starTrekService.createIssueForPlusPointsTopupFailed(UUID.fromString(event.getEntityId()), eventId, ctx);
            } else {
                starTrekService.createIssueForGenericWorkflowError(UUID.fromString(workflowId), eventId, ctx);
            }
        } catch (Exception e) {
            // there is only one instance of this workflow and it should never crash
            log.error("Failed to create a ticket for the failed workflow {}", workflowId, e);
        }
    }
}
