package ru.yandex.travel.orders.workflows.supervisors.order;

import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.management.StarTrekService;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowMaintenanceService;

@Configuration
@RequiredArgsConstructor
public class OrderSupervisorWorkflowConfiguration {
    private final StarTrekService starTrekService;
    private final WorkflowMaintenanceService workflowMaintenanceService;

    @Bean
    public WorkflowEventHandler orderSupervisorWorkflowEventHandler() {
        return new OrderSupervisorWorkflowEventHandler(starTrekService, workflowMaintenanceService);
    }
}
