package ru.yandex.travel.orders.workflows.voucher;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.Voucher;
import ru.yandex.travel.orders.workflow.voucher.proto.EVoucherState;
import ru.yandex.travel.orders.workflows.voucher.handlers.CreatedStateHandler;
import ru.yandex.travel.orders.workflows.voucher.handlers.CreatingStateHandler;
import ru.yandex.travel.orders.workflows.voucher.handlers.NewStateHandler;
import ru.yandex.travel.orders.workflows.voucher.handlers.VoucherWorkflowService;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
@EnableConfigurationProperties(VoucherWorkflowConfigurationProperties.class)
@RequiredArgsConstructor
public class VoucherWorkflowConfiguration {
    private final VoucherWorkflowConfigurationProperties voucherWorkflowConfigurationProperties;
    private final VoucherWorkflowService voucherWorkflowService;
    private final EntityStateTransitionRepository entityStateTransitionRepository;

    @Bean
    public WorkflowEventHandler voucherWorkflowEventHandler() {
        ImmutableMap.Builder<EVoucherState, StatefulWorkflowEventHandler<EVoucherState, Voucher>> builder =
                ImmutableMap.builder();
        builder.put(EVoucherState.VS_NEW, new NewStateHandler(voucherWorkflowService));
        builder.put(EVoucherState.VS_CREATING, new CreatingStateHandler(voucherWorkflowConfigurationProperties, voucherWorkflowService));
        builder.put(EVoucherState.VS_CREATED, new CreatedStateHandler(voucherWorkflowService));
        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
