package ru.yandex.travel.orders.workflows.voucher;

import java.time.Duration;

import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.task_processor.TaskProcessorProperties;

@Validated
@Setter
@Getter
@ConfigurationProperties(value = "voucher-workflow")
public class VoucherWorkflowConfigurationProperties {
    @NotNull
    private TaskProcessorProperties checkStateTask;
    @NotNull
    private Duration checkCreatedPeriod;
    @NotNull
    private Duration checkCreatedTimeout;
    @NotNull
    private Integer maxGenerateTries;
}
