package ru.yandex.travel.orders.workflows.voucher.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.Voucher;
import ru.yandex.travel.orders.workflow.voucher.proto.EVoucherState;
import ru.yandex.travel.orders.workflow.voucher.proto.TGenerateVoucher;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
@RequiredArgsConstructor
public class CreatedStateHandler extends AnnotatedStatefulWorkflowEventHandler<EVoucherState, Voucher> {
    private final VoucherWorkflowService voucherWorkflowService;

    @HandleEvent
    public void handleGenerateVoucher(TGenerateVoucher event, StateContext<EVoucherState, Voucher> context) {
        Voucher voucher = context.getWorkflowEntity();
        log.info("Updating voucher for order {}, new version is {}", voucher.getOrderPrettyId(), voucher.getVersion());
        voucherWorkflowService.generateVoucher(context);
    }
}
