package ru.yandex.travel.orders.workflows.voucher.jobs;

import java.util.UUID;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.workflows.voucher.VoucherWorkflowConfigurationProperties;
import ru.yandex.travel.spring.tx.ForcedRollbackTxManagerWrapper;
import ru.yandex.travel.task_processor.TaskProcessor;
import ru.yandex.travel.task_processor.TaskProcessorHelper;

@Configuration
@RequiredArgsConstructor
@EnableConfigurationProperties(VoucherWorkflowConfigurationProperties.class)
public class VoucherTaskProcessorsConfiguration {
    private final VoucherWorkflowConfigurationProperties voucherWorkflowConfigurationProperties;

    private final VoucherCheckStateTask voucherRefreshService;

    private final ForcedRollbackTxManagerWrapper forcedRollbackTxManagerWrapper;

    @Bean
    public TaskProcessor<UUID> checkStateTaskProcessor() {
        return TaskProcessorHelper.simpleTaskProcessor(voucherRefreshService, forcedRollbackTxManagerWrapper,
                voucherWorkflowConfigurationProperties.getCheckStateTask());
    }
}
