CREATE TABLE financial_events (
    id bigint not null,
    original_event_id bigint,
    order_id uuid,
    order_pretty_id varchar(128),
    order_item_id uuid,
    billing_client_id bigint,
    billing_contract_id varchar(128),
    type varchar(32),
    accrual_at timestamp,
    payout_at timestamp,
    partner_amount numeric,
    partner_currency varchar(20),
    partner_refund_amount numeric,
    partner_refund_currency varchar(20),
    fee_amount numeric,
    fee_currency varchar(20),
    fee_refund_amount numeric,
    fee_refund_currency varchar(20),
    version int,
    processed bool,

    primary key(id),
    foreign key(original_event_id) references financial_events(id),
    foreign key(order_id) references orders(id),
    foreign key(order_item_id) references order_items(id)
);

create sequence financial_events_id_seq;

create index financial_events_order_item_id_idx on financial_events(order_item_id);
create index financial_events_processed_idx on financial_events(processed);
