CREATE TABLE billing_transactions (
    id bigint not null,
    original_transaction_id bigint,
    source_financial_event_id bigint,
    transaction_type varchar(32),
    payment_type varchar(32),
    partner_id bigint,
    client_id bigint,
    trust_payment_id varchar(128),
    service_order_id varchar(128),
    value_amount numeric,
    value_currency varchar(20),
    created_at timestamp,
    payout_at timestamp,
    accounting_act_at timestamp,
    version int,
    exported_to_yt bool,
    scheduled_for_payout bool,

    primary key(id),
    foreign key(original_transaction_id) references billing_transactions(id),
    foreign key(source_financial_event_id) references financial_events(id)
);

create sequence billing_transactions_id_seq start with 10000;

create index billing_transactions_source_financial_event_id_idx on billing_transactions(source_financial_event_id);
create index billing_transactions_exported_to_yt_payout_at_idx on billing_transactions(exported_to_yt, payout_at);
create index billing_transactions_scheduled_for_payout_accounting_act_at_idx on billing_transactions(scheduled_for_payout, accounting_act_at);
