create table billing_partner_configs(
    billing_client_id bigint,
    description varchar(256),
    comment varchar(256),
    agreement_active bool,
    generate_transactions bool,
    export_to_yt bool,

    primary key(billing_client_id)
);


-- Partners import
-- travelline
insert into billing_partner_configs(billing_client_id, agreement_active, generate_transactions, export_to_yt)
select distinct financial_client_id, true, true, true from travelline_agreements;
-- dolphin
insert into billing_partner_configs(billing_client_id, agreement_active, generate_transactions, export_to_yt)
select distinct billing_client_id, true, true, true from financial_events fe
where not exists(select 1 from billing_partner_configs p where p.billing_client_id = fe.billing_client_id);


-- Foreign keys
alter table travelline_agreements add constraint financial_client_id_fkey
foreign key (financial_client_id) references billing_partner_configs(billing_client_id);

alter table financial_events add constraint billing_client_id_fkey
foreign key (billing_client_id) references billing_partner_configs(billing_client_id);

alter table billing_transactions add constraint partner_id_fkey
foreign key (partner_id) references billing_partner_configs(billing_client_id);
