CREATE TABLE promo_actions(
    id bigint,
    name varchar,
    created_at timestamp,
    updated_at timestamp,
    version bigint,
    primary key(id)
);
CREATE SEQUENCE promo_actions_id_seq start with 1000;

CREATE TABLE promo_codes(
    id bigint,
    promo_action_id bigint REFERENCES promo_actions(id),
    code varchar unique,
    nominal decimal,
    created_at timestamp,
    version bigint,
    primary key(id)
);
CREATE SEQUENCE promo_codes_id_seq start WITH 1000;

CREATE TABLE promo_code_activations(
    id bigint,
    promo_code_id bigint references promo_codes(id),
    passport_id varchar,
    activated_at timestamp,
    updated_at timestamp,
    version bigint,
    primary key(id)
);
CREATE SEQUENCE promo_code_activations_id_seq start WITH 1000;

CREATE TABLE promo_code_applications(
    id bigint,
    promo_code_activation_id bigint references promo_code_activations(id),
    order_id UUID references orders(id),
    active boolean,
    applied_at timestamp,
    version bigint,
    primary key(id)
);

CREATE sequence promo_code_applications_id_seq start WITH 1000;
