DROP TABLE promo_code_applications;
DROP SEQUENCE promo_code_applications_id_seq;

DROP TABLE promo_code_activations;
DROP SEQUENCE promo_code_activations_id_seq;

DROP TABLE promo_codes;
DROP SEQUENCE promo_codes_id_seq;


DROP TABLE promo_actions;
DROP SEQUENCE promo_actions_id_seq;

CREATE TABLE promo_actions(
    id uuid,
    name varchar,
    created_at timestamp,
    updated_at timestamp,
    version bigint,
    primary key(id)
);

CREATE TABLE promo_codes(
    id uuid,
    promo_action_id uuid REFERENCES promo_actions(id),
    code varchar unique,
    nominal decimal,
    valid_till timestamp,
    created_at timestamp,
    version bigint,
    primary key(id)
);

CREATE TABLE promo_code_activations(
    id uuid,
    promo_code_id uuid references promo_codes(id),
    passport_id varchar,
    activated_at timestamp,
    updated_at timestamp,
    version bigint,
    primary key(id)
);
CREATE SEQUENCE promo_code_activations_id_seq start WITH 1000;

CREATE TABLE promo_code_applications(
    id uuid,
    promo_code_activation_id uuid references promo_code_activations(id),
    order_id UUID references orders(id),
    active boolean,
    applied_at timestamp,
    version bigint,
    primary key(id)
);

CREATE sequence promo_code_applications_id_seq start WITH 1000;
