create table promo_2020_08_taxi_codes(
    code        varchar(64)     not null,
    added_at    timestamp       not null,
    expires_at  timestamp       not null,
    used_at     timestamp,

    primary key(code)
);

create table promo_2020_08_taxi_orders(
    order_id            uuid            not null,
    status              varchar(32)     not null,
    next_check_at       timestamp,
    email               varchar(512),
    email_scheduled_at  timestamp,
    promo_code          varchar(64),
    sent_at             timestamp,
    notification_id     uuid,
    version             int,

    primary key(order_id),
    unique(promo_code),
    foreign key(order_id) references orders(id),
    foreign key(promo_code) references promo_2020_08_taxi_codes(code),
    foreign key(notification_id) references notifications(id)
);

create index orders_created_at_idx on orders(created_at);
create index promo_2020_08_taxi_orders_next_check_at_idx on promo_2020_08_taxi_orders(next_check_at);
