create table bank_order_payments(
    payment_batch_id varchar(64),
    created_at timestamp,
    updated_at timestamp,
    version int,

    primary key(payment_batch_id)
);

create table bank_orders (
    id bigint,
    created_at timestamp,
    updated_at timestamp,
    version int,
    service_id bigint,
    payment_batch_id varchar(64),
    bank_order_id varchar(128),
    trantime timestamp,
    eventtime date,
    status varchar(64),
    sum decimal,
    oebs_payment_status varchar(64),

    primary key(id),
    foreign key (payment_batch_id) references bank_order_payments(payment_batch_id),
    unique (payment_batch_id, bank_order_id)
);

create sequence bank_order_id_seq start with 1;
create index bank_orders_payment_batch_id_bank_order_id_idx on bank_orders(payment_batch_id, bank_order_id);
create index bank_orders_eventtime_oebs_payment_status_idx on bank_orders(oebs_payment_status, eventtime);

create table bank_order_details (
    id bigint,
    created_at timestamp,
    updated_at timestamp,
    version int,
    payment_batch_id varchar(64),
    trust_payment_id varchar(128),
    trust_refund_id varchar(128),
    sum decimal,
    currency varchar(20),
    payment_type varchar(64),
    transaction_type varchar(64),
    handling_time date,
    payment_time date,
    contract_id bigint,
    service_order_id varchar(128),
    agency_commission decimal,

    primary key (id),
    foreign key (payment_batch_id) references bank_order_payments(payment_batch_id)
);

create sequence bank_order_details_id_seq start with 1;
create index bank_order_details_payment_batch_id_idx on bank_order_details(payment_batch_id);
