create table order_aggregate_states
(
    id                                    uuid    not null,
    order_pretty_id                       varchar not null,
    order_type                            int     not null default 0,
    reserved_to                           timestamp,
    created_at                            timestamp,
    updated_at                            timestamp,
    payment_error_display_state           int              default 0,
    payment_url                           varchar,
    hotel_order_aggregate_state           int              default 0,
    max_pending_till                      timestamp,
    train_order_aggregate_state           int              default 0,
    train_order_insurance_aggregate_state int              default 0,
    has_train_error                       bool             default false,
    train_error_message                   varchar,
    train_error_message_code              int              default 0,
    train_error_type                      int              default 0,

    primary key (id),
    foreign key (id) references orders (id)
);

create table order_aggregate_state_changes
(
    id         bigint,
    order_id   uuid not null,
    created_at timestamp,

    primary key (id)
);

create sequence order_aggregate_state_change_id_seq start with 100;

create index order_aggregate_state_pretty_id_idx on order_aggregate_states (order_pretty_id);
