CREATE TABLE pending_invoices
(
    id                 uuid NOT NULL,
    title              varchar,
    order_id           uuid,
    state              int,
    owner_workflow_id  uuid,
    workflow_id        uuid,
    created_at         timestamp,
    updated_at         timestamp,
    closed_at          timestamp,
    last_transition_at timestamp,
    version            int,

    PRIMARY KEY (id),
    FOREIGN KEY (order_id) REFERENCES orders (id)
);

CREATE TABLE pending_invoice_items
(
    id               bigint NOT NULL,
    invoice_id       uuid,
    fiscal_item_id   bigint,
    price_amount     numeric,
    price_currency   varchar(20),
    created_at       timestamp,
    updated_at       timestamp,
    version          int,
    item_position    int,

    PRIMARY KEY (id),
    FOREIGN KEY (invoice_id) REFERENCES pending_invoices (id),
    FOREIGN KEY (fiscal_item_id) REFERENCES fiscal_items (id)
);

CREATE TABLE payment_schedules
(
    id                          uuid not null,
    order_id                    uuid,
    initial_pending_invoice_id  uuid,
    state                       int,
    workflow_id                 uuid,
    last_transition_at          timestamp,
    created_at                  timestamp,
    updated_at                  timestamp,
    version                     int,

    PRIMARY KEY (id),
    FOREIGN KEY (order_id) REFERENCES orders (id),
    FOREIGN KEY (initial_pending_invoice_id) REFERENCES pending_invoices (id)
);

CREATE TABLE payment_schedule_items
(
    id                     uuid not null,
    schedule_id            uuid,
    pending_invoice_id     uuid,
    ratio                  numeric,
    name                   varchar,
    payment_starts_at      timestamp,
    cancellation_starts_at timestamp,
    created_at             timestamp,
    updated_at             timestamp,
    version                int,
    item_position          int,

    primary key (id),
    foreign key (schedule_id) references payment_schedules (id)
);

ALTER TABLE invoices
    ADD COLUMN pending_invoice_id uuid;

ALTER TABLE orders
    ADD COLUMN use_deferred_payment boolean;

ALTER TABLE orders
    ADD COLUMN active_payment_workflow_id uuid;

CREATE INDEX pending_invoice_order_idx ON pending_invoices (order_id);
CREATE INDEX pending_invoice_item_invoice_idx ON pending_invoice_items (invoice_id);
CREATE SEQUENCE pending_invoice_items_id_seq START WITH 1000;
create index payment_schedule_order_idx on payment_schedules (order_id);
create index payment_schedule_item_schedule_idx on payment_schedule_items (schedule_id);
