create table REVINFO
(
  id        bigint,
  timestamp bigint,
  primary key (id)
);

create sequence revision_entity_id_seq;

create table fiscal_items_aud
(
  id             bigint,
  rev            bigint not null,
  revtype        smallint,
  order_item_id  bigint,
  item_position  int,
  product_id     varchar(256),
  title          varchar(1024),
  money_amount   numeric,
  money_currency varchar(20),
  vat_type       varchar(128),

  primary key (id, rev)
);
create table settlement_items_aud
(
  id             bigint,
  rev            bigint not null,
  revtype        smallint,
  order_item_id  bigint,
  account_id     UUID,
  item_position  int,
  money_amount   numeric,
  money_currency varchar(20),

  primary key (id, rev)
);
create table order_items_aud
(
  id            bigint,
  rev           bigint not null,
  revtype       smallint,
  order_id      UUID,
  item_position int,
  expires_at    timestamp,
  provider_id   varchar(256),
  state         varchar(128),
  version       int,

  primary key (id, rev)
);


