create table order_search_documents(
    id UUID,
    order_id UUID,
    pretty_id varchar(128),
    order_created_at timestamp,
    order_updated_at timestamp,
    provider_ids tsvector,
    phone varchar(128),
    email varchar(256),
    participants_names tsvector,
    created_at timestamp,
    updated_at timestamp,
    primary key(id),
    foreign key(order_id) references orders(id)
);

CREATE INDEX IF NOT EXISTS order_srch_email_trgm_idx ON order_search_documents USING GIST (email gist_trgm_ops);
CREATE INDEX IF NOT EXISTS order_srch_phone_trgm_idx ON order_search_documents USING GIST (phone gist_trgm_ops);
CREATE INDEX IF NOT EXISTS order_srch_pretty_trgm_idx ON order_search_documents USING GIST (pretty_id gist_trgm_ops);

CREATE INDEX IF NOT EXISTS order_srch_providers_ts_idx ON order_search_documents USING GIN (provider_ids);
CREATE INDEX IF NOT EXISTS order_srch_names_ts_idx ON order_search_documents USING GIN (participants_names);

CREATE INDEX IF NOT EXISTS order_srch_order_id_idx ON order_search_documents (order_id);
CREATE INDEX IF NOT EXISTS order_srch_order_created_idx ON order_search_documents (order_created_at);
CREATE INDEX IF NOT EXISTS order_srch_order_updated_idx ON order_search_documents (order_updated_at);
CREATE INDEX IF NOT EXISTS order_srch_created_at_idx ON order_search_documents (created_at);
CREATE INDEX IF NOT EXISTS order_srch_updated_at_idx ON order_search_documents (updated_at);
