insert into email_attachments (id, email_id, attachment_type, filename, mime_type, data, provider_data)
select uuid_generate_v1(), e.id, 'url_attachment', att.filename, att.mime_type, decode(att.data, 'base64'),
       CASE WHEN o.document_url IS NOT NULL THEN concat('{"url": "', o.document_url, '"}')::jsonb ELSE null END
from emails e
CROSS JOIN LATERAL (
    SELECT att.elem->>'filename' as filename,
           att.elem->>'data' as data,
           att.elem->>'mime_type' as mime_type
           FROM jsonb_array_elements(e.attachments) as att(elem)
    ) att
cross join orders o
where e.attachments IS NOT NULL AND e.attachments <> '{}'::JSONB
AND o.id = e.order_id
AND e.state = 3;
