DROP INDEX order_srch_rrn_idx;
DROP INDEX order_srch_card_trgm_idx;

ALTER TABLE order_search_documents ADD COLUMN purchase_token tsvector;
ALTER TABLE order_search_documents ALTER COLUMN card_mask TYPE tsvector USING to_tsvector(card_mask);
ALTER TABLE order_search_documents ALTER COLUMN rrn TYPE tsvector USING to_tsvector(rrn);

CREATE INDEX IF NOT EXISTS order_srch_purchase_token_ids ON order_search_documents USING GIN (purchase_token);
CREATE INDEX IF NOT EXISTS order_srch_card_trgm_idx ON order_search_documents USING GIN (card_mask);
CREATE INDEX IF NOT EXISTS order_srch_rrn_idx ON order_search_documents USING GIN (rrn);
