CREATE TEMP TABLE notifications_temp_table
AS
SELECT uuid_generate_v4() as id, uuid_generate_v4() as workflow_id,
       emails.id as old_id, order_id, workflow_id as old_workflow_id, emails.state,
       emails.created_at, emails.updated_at,
       emails.last_transition_at, order_workflow_id, campaign,
       target, arguments, order_pretty_id
FROM emails
INNER JOIN workflows ON emails.workflow_id = workflows.id
WHERE emails.state = 3 and workflows.state = 1;

CREATE TEMP TABLE attachments_temp_table
AS
SELECT email_attachments.id,
       uuid_generate_v4() as workflow_id,
       notifications_temp_table.id as notification_id,
       notifications_temp_table.workflow_id as notification_workflow_id,
       notifications_temp_table.created_at,
       notifications_temp_table.updated_at,
       notifications_temp_table.last_transition_at,
       email_attachments.attachment_type, email_attachments.filename, email_attachments.mime_type,
       email_attachments.data, email_attachments.provider_data
FROM email_attachments
INNER JOIN notifications_temp_table ON email_attachments.email_id = notifications_temp_table.old_id;

insert into workflows (id, entity_id, entity_type, created_at, updated_at, next_reservation_refresh_at, version,
                       sleep_till, supervisor_id, state)
SELECT workflow_id, id, 'notification', created_at, updated_at, null, 0, null, 'd2a7d7a8-01d6-400c-8be5-0edfbe49c38e', 1
FROM notifications_temp_table;

insert into workflows (id, entity_id, entity_type, created_at, updated_at, next_reservation_refresh_at, version,
                       sleep_till, supervisor_id, state)
SELECT workflow_id, id, 'attachment', created_at, updated_at, null, 0, null, notification_workflow_id, 1
FROM attachments_temp_table;

insert into notifications (id, order_id, workflow_id, state, created_at, updated_at, last_transition_at,
                           order_workflow_id, order_pretty_id, preparing_attachments_till, channel, send_complete_message,
                           channel_info)
SELECT id, order_id, workflow_id, 5, created_at, updated_at, last_transition_at,
       order_workflow_id, order_pretty_id, null, 'email', false,
       concat('{"@type": "EmailChannelInfo", "target": "', target, '", "campaign": "', campaign, '", "arguments": ', arguments, '}')::jsonb
FROM notifications_temp_table;

insert into attachments (id, workflow_id, state, notification_id, notification_workflow_id, created_at, updated_at,
                         last_transition_at, filename, mime_type, data, required, provider, provider_data)
SELECT id, workflow_id, 2, notification_id, notification_workflow_id, created_at, updated_at,
       last_transition_at, filename, mime_type, data, true, 'im',
       concat('{"@type": "ImAttachmentProviderData", "blank_request": ', provider_data, '}')::jsonb
FROM attachments_temp_table
where attachment_type = 'im_attachment';

insert into attachments (id, workflow_id, state, notification_id, notification_workflow_id, created_at, updated_at,
                         last_transition_at, filename, mime_type, data, required, provider, provider_data)
SELECT id, workflow_id, 2, notification_id, notification_workflow_id, created_at, updated_at,
       last_transition_at, filename, mime_type, data, true, 'url',
       concat('{"@type": "UrlAttachmentProviderData", "url": "', provider_data->>'url', '"}')::jsonb
FROM attachments_temp_table
where attachment_type = 'url_attachment';

DROP TABLE notifications_temp_table;
DROP TABLE attachments_temp_table;
