WITH fully_refunded_invoices(invoice_id) AS (
    select ii.invoice_id from invoice_items ii group by ii.invoice_id having sum(ii.price) = 0
),
     invoices_refunded_at(invoice_id, refunded_at) AS (
         select inv.id, we.created_at refunded_at
         from workflow_events we
                  left join invoices inv on we.workflow_id = inv.workflow_id
         where class_name = 'ru.yandex.travel.orders.workflow.invoice.proto.TPaymentRefund'
     ),
     invoices_cleared_at(invoice_id, cleared_at) AS (
         select est.entity_id, est.transition_at as cleared_at
         from entity_state_transitions est
         where est.entity_type = 'trust_invoice'
           and est.from_state = 3 /* IS_HOLD */
           and est.to_state = 5 /* IS_CLEARING */
     ),
     invoice_states(invoice_id, new_state) AS (
         select f.invoice_id,
       case when r.refunded_at > c.cleared_at then 9 /* IS_REFUNDED */ else 7 /* IS_CANCELLED */end new_state
from fully_refunded_invoices f
         left join invoices_refunded_at r on f.invoice_id = r.invoice_id
         left join invoices_cleared_at c on f.invoice_id = c.invoice_id
         left join invoices i on f.invoice_id = i.id
where i.state = 6 /* CLEARED */
     )
update invoices i set state = invoice_states.new_state
from invoice_states where id = invoice_states.invoice_id;
