WITH current_order_invoices(order_id, current_invoice_id) AS (
    select o.id order_id, last_value(i.id) over (partition by i.order_id order by i.created_at) current_invoice_id
    from orders o
             left join invoices i on o.id = i.order_id
)
update orders o set current_invoice_id = coi.current_invoice_id
from current_order_invoices coi where coi.order_id = id and o.current_invoice_id is null;

