/*
    Sample:
        select get_enum_name('%EOrderItemState', state) state_hr from xxx
    To drop:
        drop function get_enum_name(varchar, int);
 */
CREATE or replace function get_enum_name(class_name varchar, value int) returns varchar
language plpgsql
as $$
declare
    order_state varchar;
begin

    select string_value
    from protobuf_enum_dictionary
    where proto_class_name like class_name and ordinal_value = value
        into order_state;

    return order_state;

end; $$
;
