/*
    Sample:
        select local_to_utc('2021-06-29 17:35:13')        => 2021-06-29 14:35:13 (if we're at UTC+3)
        select local_to_utc('2021-06-29 17:35')           => 2021-06-29 14:35:00
        select local_to_utc('2021-06-29')                 => 2021-06-28 21:00:00
    To drop:
        drop function local_to_utc(varchar);
 */
CREATE or replace function local_to_utc(timestamp_without_timezone varchar) returns timestamp
    language plpgsql
as
$$
declare
    utc_date timestamp;
begin
    select timestamp_without_timezone::timestamp with time zone at time zone 'UTC-0'
    into utc_date;

    return utc_date;
end;
$$
;
