/*
    usage:
        select * from copy_financial_event_new_partner_sql('_YA_PRETTY_ID_', _BILLING_CLIENT_ID_, _BILLING_CONTRACT_ID_);

    to drop use:
        drop function copy_financial_event_new_partner_sql(varchar, int, int);
*/
CREATE or replace function copy_financial_event_new_partner_sql(
    p_pretty_id varchar, p_new_billing_client_id int, p_new_billing_contract_id int) returns table(event_copy_sql text)
language plpgsql
as $$
declare
begin

    RETURN QUERY select * from (
        select '/* copy of ' || e.type || ' event ' || e.id || ', sum ' ||
                   (coalesce(e.partner_amount,0)+coalesce(e.fee_amount,0)+
                    coalesce(e.partner_refund_amount,0)+coalesce(e.fee_refund_amount,0)+
                    coalesce(e.promo_code_partner_amount,0)+coalesce(e.promo_code_fee_amount,0)+
                    coalesce(e.promo_code_partner_refund_amount,0)+coalesce(e.promo_code_fee_refund_amount,0)+
                    coalesce(e.plus_partner_amount,0)+coalesce(e.plus_fee_amount,0)+
                    coalesce(e.plus_partner_refund_amount,0)+coalesce(e.plus_fee_refund_amount,0)+
                    coalesce(e.partner_fee_amount,0)+coalesce(e.partner_fee_refund_amount,0)) ||
               ', fee rate ' ||
                    round(100*( coalesce(e.fee_amount,0)+coalesce(e.promo_code_fee_amount,0)+
                                coalesce(e.fee_refund_amount,0)+coalesce(e.promo_code_fee_refund_amount,0))/
                       (coalesce(e.partner_amount,0)+coalesce(e.fee_amount,0)+
                        coalesce(e.partner_refund_amount,0)+coalesce(e.fee_refund_amount,0)+
                        coalesce(e.promo_code_partner_amount,0)+coalesce(e.promo_code_fee_amount,0)+
                        coalesce(e.promo_code_partner_refund_amount,0)+coalesce(e.promo_code_fee_refund_amount,0)+
                        coalesce(e.partner_fee_amount,0)+coalesce(e.partner_fee_refund_amount,0)), 2) || '% */ ' ||
               'INSERT INTO financial_events (' ||
               'id, original_event_id, ' ||
               'order_id, order_pretty_id, order_item_id, ' ||
               'billing_client_id, billing_contract_id, type, ' ||
               'accrual_at, payout_at, ' ||
               'partner_amount, partner_currency, ' ||
               'partner_refund_amount, partner_refund_currency, ' ||
               'fee_amount, fee_currency, fee_refund_amount, fee_refund_currency, ' ||
               'version, processed, accounting_act_at, ' ||
               'promo_code_partner_amount, promo_code_partner_currency, ' ||
               'promo_code_fee_amount, promo_code_fee_currency, ' ||
               'promo_code_partner_refund_amount, promo_code_partner_refund_currency, ' ||
               'promo_code_fee_refund_amount, promo_code_fee_refund_currency, ' ||
               'plus_partner_amount, plus_partner_currency, ' ||
               'plus_partner_refund_amount, plus_partner_refund_currency, ' ||
               'plus_fee_amount, plus_fee_currency, ' ||
               'plus_fee_refund_amount, plus_fee_refund_currency, ' ||
               'partner_fee_amount, partner_fee_currency, ' ||
               'partner_fee_refund_amount, partner_fee_refund_currency, ' ||
               'payment_scheme, comment) ' ||
               'VALUES (nextval(''financial_events_id_seq''), ' || (case when e.original_event_id is null then 'null'
                    else '(select id from financial_events where comment = ''manual copy of event ' || e.original_event_id || ''')' end) || ', ' ||
               '''' || e.order_id || ''', ''' || e.order_pretty_id || ''', ''' || e.order_item_id || ''', ' ||
               '' || p_new_billing_client_id || ', ' || p_new_billing_contract_id || ', ''' || e.type || ''', ' ||
               'now() at time zone ''UTC-0'', greatest(now() at time zone ''UTC-0'', ''' || e.payout_at || '''), ' ||
               '' || coalesce(e.partner_amount::text, 'null') || ', ' || coalesce('''' || e.partner_currency || '''', 'null') || ', ' ||
               '' || coalesce(e.partner_refund_amount::text, 'null') || ', ' || coalesce('''' || e.partner_refund_currency || '''', 'null') || ', ' ||
               '' || coalesce(e.fee_amount::text, 'null') || ', ' || coalesce('''' || e.fee_currency || '''', 'null') || ', ' ||
               '' || coalesce(e.fee_refund_amount::text, 'null') || ', ' || coalesce('''' || e.fee_refund_currency || '''', 'null') || ', ' ||
               '0, false, greatest(now() at time zone ''UTC-0'', ''' || e.accounting_act_at || '''), ' ||
               '' || coalesce(e.promo_code_partner_amount::text, 'null') || ', ' || coalesce('''' || e.promo_code_partner_currency || '''', 'null') || ', ' ||
               '' || coalesce(e.promo_code_fee_amount::text, 'null') || ', ' || coalesce('''' || e.promo_code_fee_currency || '''', 'null') || ', ' ||
               '' || coalesce(e.promo_code_partner_refund_amount::text, 'null') || ', ' || coalesce('''' || e.promo_code_partner_refund_currency || '''', 'null') || ', ' ||
               '' || coalesce(e.promo_code_fee_refund_amount::text, 'null') || ', ' || coalesce('''' || e.promo_code_fee_refund_currency || '''', 'null') || ', ' ||
               '' || coalesce(e.plus_partner_amount::text, 'null') || ', ' || coalesce('''' || e.plus_partner_currency || '''', 'null') || ', ' ||
               '' || coalesce(e.plus_partner_refund_amount::text, 'null') || ', ' || coalesce('''' || e.plus_partner_refund_currency || '''', 'null') || ', ' ||
               '' || coalesce(e.plus_fee_amount::text, 'null') || ', ' || coalesce('''' || e.plus_fee_currency || '''', 'null') || ', ' ||
               '' || coalesce(e.plus_fee_refund_amount::text, 'null') || ', ' || coalesce('''' || e.plus_fee_refund_currency || '''', 'null') || ', ' ||
               '' || coalesce(e.partner_fee_amount::text, 'null') || ', ' || coalesce('''' || e.partner_fee_currency || '''', 'null') || ', ' ||
               '' || coalesce(e.partner_fee_refund_amount::text, 'null') || ', ' || coalesce('''' || e.partner_fee_refund_currency || '''', 'null') || ', ' ||
               '''' || e.payment_scheme || ''', ''manual copy of event '' || ' || e.id || ');' event_copy_sql
        from financial_events e
        where e.order_pretty_id = p_pretty_id
    ) t;

end; $$
;
