/*
    usage:
        with refunded events skipped:
            select * from create_full_refund_financial_event_sql('_YA_PRETTY_ID_');
        with refunded events included:
            select * from create_full_refund_financial_event_sql('_YA_PRETTY_ID_', /*skip_refunded*/false);

    to drop use:
        drop function create_full_refund_financial_event_sql(varchar, bool);
*/
CREATE or replace function create_full_refund_financial_event_sql(
    p_pretty_id varchar, p_skip_refunded bool default true) returns table(event_refund_sql text)
language plpgsql
as $$
declare
begin

    RETURN QUERY select * from (
        -- create full refund SQL
        select '/*refund of ' || e.total || ', ' ||
               'fee rate ' || round(100*e.total_fee/e.total, 2) || '% */ ' ||
               'INSERT INTO financial_events (' ||
               'id, original_event_id, ' ||
               'order_id, order_pretty_id, order_item_id, ' ||
               'billing_client_id, billing_contract_id, type, ' ||
               'accrual_at, payout_at, ' ||
               'partner_amount, partner_currency, partner_refund_amount, partner_refund_currency, ' ||
               'fee_amount, fee_currency, fee_refund_amount, fee_refund_currency, ' ||
               'version, processed, accounting_act_at, ' ||
               'promo_code_partner_amount, promo_code_partner_currency, promo_code_fee_amount, promo_code_fee_currency, ' ||
               'promo_code_partner_refund_amount, promo_code_partner_refund_currency, ' ||
               'promo_code_fee_refund_amount, promo_code_fee_refund_currency, ' ||
               'plus_partner_amount, plus_partner_currency, ' ||
               'plus_partner_refund_amount, plus_partner_refund_currency, ' ||
               'plus_fee_amount, plus_fee_currency, ' ||
               'plus_fee_refund_amount, plus_fee_refund_currency, ' ||
               'partner_fee_amount, partner_fee_currency, partner_fee_refund_amount, partner_fee_refund_currency, ' ||
               'payment_scheme, comment) ' ||
               'VALUES (nextval(''financial_events_id_seq''), ' || e.id || ', ' ||
               '''' || e.order_id || ''', ''' || e.order_pretty_id || ''', ''' || e.order_item_id || ''', ' ||
               '' || e.billing_client_id || ', ' || e.billing_contract_id || ', ''refund'', ' ||
               'now() at time zone ''UTC-0'', greatest(now() at time zone ''UTC-0'', ''' || e.payout_at || '''), ' ||
               'null, null, ' || coalesce(e.partner_amount::text, 'null') || ', ' || coalesce('''' || e.partner_currency || '''', 'null') || ', ' ||
               'null, null, ' || coalesce(e.fee_amount::text, 'null') || ', ' || coalesce('''' || e.fee_currency || '''', 'null') || ', ' ||
               '0, false, greatest(now() at time zone ''UTC-0'', ''' || e.accounting_act_at || '''), ' ||
               'null, null, null, null, ' ||
               '' || coalesce(e.promo_code_partner_amount::text, 'null') || ', ' || coalesce('''' || e.promo_code_partner_currency || '''', 'null') || ', ' ||
               '' || coalesce(e.promo_code_fee_amount::text, 'null') || ', ' || coalesce('''' || e.promo_code_fee_currency || '''', 'null') || ', ' ||
               '' || coalesce(e.plus_partner_amount::text, 'null') || ', ' || coalesce('''' || e.plus_partner_currency || '''', 'null') || ', ' ||
               '' || coalesce(e.plus_partner_refund_amount::text, 'null') || ', ' || coalesce('''' || e.plus_partner_refund_currency || '''', 'null') || ', ' ||
               '' || coalesce(e.plus_fee_amount::text, 'null') || ', ' || coalesce('''' || e.plus_fee_currency || '''', 'null') || ', ' ||
               '' || coalesce(e.plus_fee_refund_amount::text, 'null') || ', ' || coalesce('''' || e.plus_fee_refund_currency || '''', 'null') || ', ' ||
               'null, null, ' || coalesce(e.partner_fee_amount::text, 'null') || ', ' || coalesce('''' || e.partner_fee_currency || '''', 'null') || ', ' ||
               '''' || e.payment_scheme || ''', ''manual refund'');' refund_sql
        FROM
          (
            select *, coalesce(partner_amount,0)+coalesce(fee_amount,0)+
              coalesce(promo_code_partner_amount,0)+coalesce(promo_code_fee_amount,0)+
              coalesce(plus_partner_amount,0)+coalesce(plus_fee_amount,0)                          as total,
              coalesce(fee_amount,0)+coalesce(promo_code_fee_amount,0)+coalesce(plus_fee_amount,0) as total_fee
            from financial_events
          ) e
        left join financial_events re on re.original_event_id = e.id
        where
            (p_skip_refunded = false or re.id is null) and -- no existing refund event, comment this line out if necessary
            e.type = 'payment' and e.order_pretty_id = p_pretty_id
    ) t;

end; $$
;
