CREATE OR REPLACE VIEW public.view_extended_billing_transactions AS
WITH bank_order_details_id(id, yt_id, payment_batch_id, payment_time, payment_contract_id) AS (
         SELECT bank_order_details.id,
            bank_order_details.yt_id,
            bank_order_details.payment_batch_id,
            bank_order_details.payment_time,
            bank_order_details.contract_id
           FROM bank_order_details
        ),
    billing_tx_payments(btx_id, bank_order_id, payment_contract_id) AS (
         SELECT bt_1.id,
            first_value(bo_1.id) OVER (PARTITION BY bt_1.id ORDER BY bodi.payment_time DESC) AS first_value,
            first_value(bodi.payment_contract_id) OVER (PARTITION BY bt_1.id ORDER BY bodi.payment_time DESC) AS first_value
           FROM billing_transactions bt_1
             LEFT JOIN bank_order_details_id bodi ON bt_1.yt_id = bodi.yt_id
             LEFT JOIN bank_orders bo_1 ON bodi.payment_batch_id::text = bo_1.payment_batch_id::text
        )
SELECT bt.id AS bt_id,
       bt.original_transaction_id AS bt_original_transaction_id,
       bt.source_financial_event_id AS bt_source_financial_event_id,
       bt.transaction_type AS bt_transaction_type,
       bt.payment_type AS bt_payment_type,
       bt.partner_id AS bt_partner_id,
       bt.client_id AS bt_client_id,
       bt.trust_payment_id AS bt_trust_payment_id,
       bt.service_order_id AS bt_service_order_id,
       CASE
           WHEN transaction_type = 'refund' THEN -bt.value_amount
           ELSE bt.value_amount
           END AS bt_value_amount,
       bt.value_currency AS bt_value_currency,
       bt.created_at AS bt_created_at,
       bt.exported_to_yt AS bt_exported_to_yt,
       bt.act_committed AS bt_act_committed,
       timezone('UTC'::text, bt.payout_at) AS payout_at_utc,
       timezone('UTC'::text, bt.accounting_act_at) AS accounting_act_at_utc,
       fe.order_pretty_id,
       vfhoi.hotel_partner_number,
       vfhoi.hotel_name,
       vfhoi.hotel_original_id,
       vfhoi.check_in,
       vfhoi.check_out,
       vfhoi.fiscal_price AS hotel_fiscal_price,
       vfhoi.item_type AS hotel_item_type,
       bo.payment_batch_id AS bank_payment_batch_id,
       bo.bank_order_id,
       bo.status AS bank_order_status,
       bo.oebs_payment_status AS bank_order_oebs_payment_status,
       bo.eventtime AS bank_order_payment_date,
       bo.description AS bank_order_description,
       btp.payment_contract_id,
       vfhoi.agreement_inn,
       vfhoi.permalink,
       vfhoi.order_created_at AS order_created_at_utc,
       timezone('Europe/Moscow'::text, timezone('UTC'::text, bt.payout_at)) AS payout_at_msk,
       timezone('Europe/Moscow'::text, timezone('UTC'::text, bt.accounting_act_at)) AS accounting_act_at_msk,
       timezone('Europe/Moscow'::text, timezone('UTC'::text, vfhoi.order_created_at)) AS order_created_at_msk,
       timezone('Europe/Moscow'::text, timezone('UTC'::text, bt.exported_to_yt_at)) AS exported_to_yt_at_msk,
       timezone('Europe/Moscow'::text, timezone('UTC'::text, bt.act_committed_at)) AS act_committed_at_msk,
       vfhoi.guest_name
FROM billing_transactions bt
         LEFT JOIN financial_events fe ON bt.source_financial_event_id = fe.id
         LEFT JOIN view_for_hotel_order_item_payload_details vfhoi ON fe.order_item_id = vfhoi.order_item_id
         LEFT JOIN billing_tx_payments btp ON bt.id = btp.btx_id
         LEFT JOIN bank_orders bo ON bo.id = btp.bank_order_id;
