-- basic enhancement of financial events table to calculate typical sums. Feel free to extend it if necessary

-- DROP VIEW view_financial_events_calculated;
CREATE OR REPLACE VIEW view_financial_events_calculated AS
WITH financial_events_fee_partner_calculation AS (
    SELECT id,
           order_id,
           order_item_id,
           order_pretty_id,
           type,
           processed,
           payment_scheme,
           payout_at,
           billing_contract_id,
           COALESCE(partner_amount, 0) + COALESCE(plus_partner_amount, 0) +
           COALESCE(promo_code_partner_amount, 0)  AS partner_total,          -- amount of money that went to hotel (ATM is 0 for refund events)
           COALESCE(partner_refund_amount, 0) + COALESCE(promo_code_partner_refund_amount, 0) +
           COALESCE(plus_partner_refund_amount, 0) AS partner_refunded_total, -- amount of money that was refunded (ATM is 0 for payment events)
           COALESCE(fee_amount, 0) + COALESCE(plus_fee_amount, 0) +
           COALESCE(promo_code_fee_amount, 0)      AS fee_total,
           COALESCE(fee_refund_amount, 0) + COALESCE(promo_code_fee_refund_amount, 0) +
           COALESCE(plus_fee_refund_amount, 0)     AS fee_refunded_total

    FROM financial_events
)
SELECT
    -- signed amount of money that went to the hotel or from the hotel for the event (+ for payments, - for refunds)
    partner_total - partner_refunded_total AS hotel_money,
    -- signed amount of feeview_for_hotel_calculate_balance
    fee_total - fee_refunded_total         AS yandex_money,
    *
FROM financial_events_fee_partner_calculation fe
;
