-- Dashboard "Partner payouts", tab "Fulfilled orders"
-- https://datalens.yandex-team.ru/zv7fpa6w5014w-partner-payouts?tab=6j
-- DROP VIEW view_for_direct_agreement_order_acts;
CREATE OR REPLACE VIEW public.view_for_direct_agreement_order_acts AS
WITH current_invoice_sum AS (
    SELECT i.order_id    AS order_id,
           sum(ii.price) AS sum
    FROM invoices i
             JOIN invoice_items ii ON i.id = ii.invoice_id
        -- postgresql performs Seq scan, adding a filter will help to decrease the size of rows it needs to scan
        and ii.fiscal_item_type = 'expedia_hotel'
    GROUP BY i.order_id
),
     billing_transactions_signed
         as (
         SELECT *,
                CASE
                    WHEN transaction_type = 'refund' THEN -value_amount
                    ELSE value_amount
                    END as signed_amount

         FROM billing_transactions
         where payment_type in ('cost', 'yandex_account_withdraw', 'reward', 'reward_account_withdraw')
           --same as in current_invoice_sum - decreasing # of rows postgres needs to scan
           AND service_id = 641
     ),
     fee_travelline AS (
         SELECT CASE
                    WHEN order_sum <= 50000 THEN 0.04
                    WHEN order_sum <= 150000 THEN 0.035
                    WHEN order_sum <= 500000 THEN 0.03
                    ELSE 0.025
                    END AS percent,
                hotel_original_id,
                month,
                year
         FROM (
                  select sum(bt.signed_amount)                              as order_sum,
                         payload #>> '{order_details, checkout_date, 1}'    as month,
                         payload #>> '{order_details, checkout_date, 0}'    as year,
                         payload -> 'order_details' ->> 'original_id'::text AS hotel_original_id
                  from order_items oi,
                       orders o,
                       billing_transactions_signed bt
                  WHERE item_type = 'travelline'
                    AND oi.order_id = o.id
                    AND bt.service_order_id = o.pretty_id
                  GROUP BY month, year, hotel_original_id
              ) _balance
     ),
     fee_bnovo AS
         (SELECT CASE
                     WHEN order_sum <= 100000 THEN 0.04
                     WHEN order_sum <= 300000 THEN 0.035
                     WHEN order_sum <= 500000 THEN 0.03
                     ELSE 0.025
                     END AS percent,
                 month,
                 year
          FROM (
                   select sum(bt.signed_amount)                           as order_sum,
                          payload #>> '{order_details, checkout_date, 1}' as month,
                          payload #>> '{order_details, checkout_date, 0}' as year
                   from order_items oi,
                        orders o,
                        billing_transactions_signed bt
                   WHERE item_type = 'bnovo'
                     AND oi.order_id = o.id
                     AND bt.service_order_id = o.pretty_id
                   GROUP BY month, year
               ) _balance
         )
SELECT o.order_id                                                                             AS order_id,
       o.pretty_id                                                                            AS order_pretty_id,
       COALESCE(o.payload ->> 'travelline_number'::text, o.payload ->> 'b_novo_number'::text) AS partner_number,
       o.hotel_name,
       o.hotel_original_id                                                                    AS original_hotel_id,
       o.check_in::date                                                                       AS check_in,
       o.check_out::date                                                                      AS check_out,
       o.fiscal_price,
       cis.sum                                                                                AS current_invoice_sum,
       CASE o.state
           WHEN 8 THEN 'CONFIRMED'::text
           WHEN 10 THEN 'REFUNDED'::text
           ELSE NULL::text
           END                                                                                AS order_state,
       o.order_created_at,
       o.item_type                                                                            AS partner_type,
       billing.sum                                                                            AS billing_sum,
       billing.fee                                                                            AS billing_fee,
       o.check_in_date                                                                        AS check_in_date,
       o.check_out_date                                                                       AS check_out_date,
       billing.promo                                                                          AS promo_sum,
       o.payload #>> '{order_details, checkout_date, 1}'                                      as month,
       o.payload #>> '{order_details, checkout_date, 0}'                                      as year,
       (CASE
            WHEN o.item_type = 'travelline' THEN
                (SELECT percent
                 from fee_travelline t
                 WHERE t.year = o.payload #>> '{order_details, checkout_date, 0}'
                   AND t.month = o.payload #>> '{order_details, checkout_date, 1}'
                   and t.hotel_original_id = o.hotel_original_id)
            WHEN o.item_type = 'bnovo' THEN
                fb.percent
            ELSE NULL
           END)                                                                               as fee
FROM view_for_hotel_order_item_payload_details o
         LEFT JOIN current_invoice_sum cis ON cis.order_id = o.order_id
    -- if fee_bnovo is put in the middle of select as fee_travelline, the query gets executed for 5 minutes (20s now)
         LEFT JOIN fee_bnovo fb ON fb.month = o.payload #>> '{order_details, checkout_date, 1}' AND
                                   fb.year = o.payload #>> '{order_details, checkout_date, 0}'
         LEFT JOIN (
    SELECT sum(bt.signed_amount) AS sum,
           sum(
               CASE
                   WHEN bt.payment_type in ('reward', 'reward_account_withdraw') THEN bt.signed_amount
                   ELSE 0
                   END)          AS fee,
           sum(
               CASE
                   WHEN bt.payment_type in ('cost', 'yandex_account_withdraw') THEN bt.signed_amount
                   ELSE 0
                   END)          AS partner,
           sum(
               CASE
                   -- here we already don't have yandex_account_topup, otherwise, it'd be needed to be filtered out
                   WHEN bt.payment_system_type = 'promocode' THEN bt.signed_amount
                   ELSE 0
                   END)          AS promo,
           bt.service_order_id
    FROM billing_transactions_signed bt
    GROUP BY bt.service_order_id) AS billing on billing.service_order_id = o.pretty_id
WHERE o.item_type in ('travelline', 'bnovo')
  AND o.state in (8, 10);

GRANT SELECT ON view_for_direct_agreement_order_acts TO orders_analytic_public;
