-- Dashboard "Partner payouts", tab "Aggregated Billing Transactions"
-- https://datalens.yandex-team.ru/zv7fpa6w5014w-partner-payouts?tab=kyd
CREATE OR REPLACE VIEW view_for_hotel_billing_info_per_order AS
WITH billing_transactions_signed
         as (
        SELECT *,
               CASE
                   WHEN transaction_type = 'refund' THEN -value_amount
                   ELSE value_amount
                   END as signed_amount

        FROM billing_transactions
        where payment_type in ('cost', 'yandex_account_withdraw', 'reward', 'reward_account_withdraw')
    ),
     billing_transactions_grouped as
         (
             select bt.transaction_type,
                    sum(bt.signed_amount)     as total_sum,
                    sum(CASE
                            WHEN bt.payment_type in ('cost', 'yandex_account_withdraw') THEN bt.signed_amount
                            ELSE 0 END)       as hotel_money,
                    sum(CASE
                            WHEN bt.payment_type in ('reward', 'reward_account_withdraw') THEN bt.signed_amount
                            ELSE 0 END)       as yandex_money,

                    fe.order_pretty_id,
                    fe.order_item_id,
                    bt.partner_id,
                    MAX(bt.act_committed_at)  as act_committed,
                    MAX(bt.payout_at)         as payout_at,
                    MAX(bt.accounting_act_at) as accounting_act_at,
                    bo.*,
                    bod.contract_id           as payment_contract_id,
                    bo.sum                    as payment_sum

             FROM billing_transactions_signed bt
                      LEFT JOIN bank_order_details bod ON bod.yt_id = bt.yt_id
                      LEFT JOIN bank_orders bo on bod.payment_batch_id = bo.payment_batch_id
                      LEFT JOIN financial_events fe on bt.source_financial_event_id = fe.id
             WHERE bt.service_id = 641
             GROUP BY bt.transaction_type,
                      fe.id,
                      bo.id,
                      bt.partner_id,
                      bod.contract_id
         )

SELECT btg.transaction_type                                                           AS bt_transaction_type,
       btg.hotel_money,
       btg.yandex_money,
       btg.total_sum,
       btg.partner_id                                                                 AS bt_partner_id,
       btg.created_at                                                                 AS bt_created_at,
       btg.act_committed                                                              AS bt_act_committed,
       timezone('UTC'::text, btg.payout_at)                                           AS payout_at_utc,
       timezone('UTC'::text, btg.accounting_act_at)                                   AS accounting_act_at_utc,
       btg.order_pretty_id,
       vfhoi.hotel_partner_number,
       vfhoi.hotel_name,
       vfhoi.hotel_original_id,
       vfhoi.guest_name,
       vfhoi.check_in,
       vfhoi.check_out,
       vfhoi.fiscal_price                                                             AS hotel_fiscal_price,
       vfhoi.item_type                                                                AS hotel_item_type,
       btg.payment_batch_id                                                           AS bank_payment_batch_id,
       btg.bank_order_id,
       btg.status                                                                     AS bank_order_status,
       btg.oebs_payment_status                                                        AS bank_order_oebs_payment_status,
       btg.eventtime                                                                  AS bank_order_payment_date,
       btg.description                                                                AS bank_order_description,
       btg.payment_contract_id,
       vfhoi.agreement_inn,
       vfhoi.permalink,
       vfhoi.order_created_at                                                         AS order_created_at_utc,
       vfhoi.order_refunded_at                                                        AS order_refunded_at_utc,
       timezone('Europe/Moscow'::text, timezone('UTC'::text, btg.payout_at))          AS payout_at_msk,
       timezone('Europe/Moscow'::text, timezone('UTC'::text, btg.accounting_act_at))  AS accounting_act_at_msk,
       timezone('Europe/Moscow'::text, timezone('UTC'::text, vfhoi.order_created_at)) AS order_created_at_msk,
       btg.payment_sum

FROM billing_transactions_grouped btg
         LEFT JOIN view_for_hotel_order_item_payload_details vfhoi ON btg.order_item_id = vfhoi.order_item_id;

GRANT SELECT ON view_for_hotel_billing_info_per_order TO orders_analytic_public;
