-- Dashboard "Partner payouts", tab "Partner Fee"
-- https://datalens.yandex-team.ru/zv7fpa6w5014w-partner-payouts?tab=k2d
-- DROP VIEW view_for_hotel_calculate_partner_fee_travelline; DROP VIEW view_for_hotel_calculate_partner_fee_bnovo;
CREATE OR REPLACE VIEW public.view_for_hotel_calculate_partner_fee_travelline AS
WITH billing_transactions_per_order AS (
    SELECT service_order_id,
           sum(CASE
                   WHEN transaction_type = 'refund' THEN -value_amount
                   ELSE value_amount
               END) as order_sum
    FROM billing_transactions
    where payment_type in ('cost', 'yandex_account_withdraw', 'reward', 'reward_account_withdraw')
      -- small optimization: decreasing # of rows postgres needs to scan
      AND service_id = 641
    GROUP BY service_order_id
)
SELECT (payload #>> '{order_details, checkout_date, 1}')::integer as month,
       (payload #>> '{order_details, checkout_date, 0}')::integer as year,
       hotel_name,
       sum(order_sum)                                             AS total_sum,
       count(*)                                                   AS orders_count,
       sum(CASE WHEN order_sum > 0 THEN 1 ELSE 0 END)             AS non_zero_orders,
       sum(CASE WHEN order_sum = 0 THEN 1 ELSE 0 END)             AS zero_orders,
       hotel_original_id
FROM view_for_hotel_order_item_payload_details vfhoi
         JOIN billing_transactions_per_order bt ON bt.service_order_id = vfhoi.pretty_id
WHERE item_type = 'travelline'
GROUP BY item_type, month, year, hotel_name, hotel_original_id;

-- --------------------------------------------------

CREATE OR REPLACE VIEW public.view_for_hotel_calculate_partner_fee_bnovo AS
WITH billing_transactions_per_order AS (
    SELECT service_order_id,
           sum(CASE
                   WHEN transaction_type = 'refund' THEN -value_amount
                   ELSE value_amount
               END) as order_sum
    FROM billing_transactions
    where payment_type in ('cost', 'yandex_account_withdraw', 'reward', 'reward_account_withdraw')
      -- small optimization: decreasing # of rows postgres needs to scan
      AND service_id = 641
    GROUP BY service_order_id
)
SELECT (payload #>> '{order_details, checkout_date, 1}')::integer AS month,
       (payload #>> '{order_details, checkout_date, 0}')::integer AS year,
       sum(order_sum)                                             AS total_sum,
       count(*)                                                   AS orders_count,
       sum(CASE WHEN order_sum > 0 THEN 1 ELSE 0 END)             AS non_zero_orders,
       sum(CASE WHEN order_sum = 0 THEN 1 ELSE 0 END)             AS zero_orders
FROM order_items oi
         JOIN orders o ON o.id = oi.order_id
         JOIN billing_transactions_per_order bt on o.pretty_id = bt.service_order_id
WHERE item_type = 'bnovo'
GROUP BY item_type, month, year;

GRANT SELECT ON view_for_hotel_calculate_partner_fee_travelline TO orders_analytic_public;
GRANT SELECT ON view_for_hotel_calculate_partner_fee_bnovo TO orders_analytic_public;
