-- DROP VIEW view_for_hotel_order_item_payload_details;

CREATE OR REPLACE VIEW public.view_for_hotel_order_item_payload_details AS
SELECT oi.id AS order_item_id,
       ((((((oi.payload -> 'order_details'::text) -> 'checkin_date'::text) ->> 0) || '-'::text) || lpad(((oi.payload -> 'order_details'::text) -> 'checkin_date'::text) ->> 1, 2, '0'::text)) || '-'::text) || lpad(((oi.payload -> 'order_details'::text) -> 'checkin_date'::text) ->> 2, 2, '0'::text) AS check_in,
    ((((((oi.payload -> 'order_details'::text) -> 'checkout_date'::text) ->> 0) || '-'::text) || lpad(((oi.payload -> 'order_details'::text) -> 'checkout_date'::text) ->> 1, 2, '0'::text)) || '-'::text) || lpad(((oi.payload -> 'order_details'::text) -> 'checkout_date'::text) ->> 2, 2, '0'::text) AS check_out,
    (oi.payload -> 'fiscal_price'::text) ->> 'value'::text AS fiscal_price,
    (oi.payload -> 'order_details'::text) ->> 'hotel_name'::text AS hotel_name,
    (oi.payload -> 'order_details'::text) ->> 'original_id'::text AS hotel_original_id,
    COALESCE(oi.payload ->> 'travelline_number'::text, oi.dolphin_order_code::text, oi.payload ->> 'b_novo_number'::text, (oi.payload -> 'confirmation_info'::text) ->> 'itinerary_id'::text, oi.payload ->> 'expedia_itinerary_id'::text) AS hotel_partner_number,
    oi.item_type,
    (oi.payload -> 'order_details'::text) ->> 'permalink'::text AS permalink,
    oi.agreement ->> 'inn'::text AS agreement_inn,
    oi.agreement ->> 'financial_client_id'::text AS agreement_client_id,
    oi.agreement ->> 'financial_contract_id'::text AS agreement_contract_id,
    timezone('UTC'::text, o.created_at) AS order_created_at,
    o.id AS order_id,
    CONCAT(oi.payload -> 'guests' -> 0 ->> 'first_name', ' ', oi.payload -> 'guests' -> 0 ->>
                                                                 'last_name')                                     AS guest_name,
    timezone('UTC'::text, oi.refunded_at)                                                                      AS order_refunded_at,
    make_date_from_order_items_payload_array(payload #> '{order_details, checkin_date}')                      AS check_in_date,
    make_date_from_order_items_payload_array(payload #> '{order_details, checkout_date}')                      AS check_out_date,
    o.current_invoice_id,
    o.pretty_id,
    o.state,
    oi.payload
FROM order_items oi
         JOIN orders o ON o.id = oi.order_id AND o.order_type::text = 'hotel_order'::text;

GRANT SELECT ON view_for_hotel_order_item_payload_details TO orders_analytic_public;
