/*
    Usage:
        select * from view_for_billing_transactions_order_balance where service_order_id = '_YA_PRETTY_ID_';
*/
CREATE
OR REPLACE VIEW public.view_for_billing_transactions_order_balance AS
select service_order_id,
       payment_type,
       payment_system_type,
       sum(case transaction_type when 'payment' then value_amount else -value_amount end) sum
from billing_transactions
-- filters for manual debug
--where service_order_id = '_YA_PRETTY_ID_'
group by service_order_id,
    payment_type,
    payment_system_type;

/*
    Usage:
        select * from view_for_financial_events_order_balance where order_pretty_id = '_YA_PRETTY_ID_';
*/
CREATE
OR REPLACE VIEW public.view_for_financial_events_order_balance AS
select *,
           -- calculate fee rate
           case total_sum
               when 0 then -1 -- something is wrong
               else fee_total / total_sum
               end fee_rate
from (
    select t.*,
       -- extras
       (user_partner + promo_partner + plus_partner) + (user_fee + promo_fee + plus_fee)  total_sum,
       (user_partner + promo_partner + plus_partner)                                      partner_total,
       (user_fee + promo_fee + plus_fee)                                                  fee_total
    from (
         select order_id,
                order_pretty_id,
                sum(case type
                        when 'payment' then coalesce(partner_amount, 0)
                        else -coalesce(partner_refund_amount, 0) end)            user_partner,
                sum(case type
                        when 'payment' then coalesce(fee_amount, 0)
                        else -coalesce(fee_refund_amount, 0) end)                user_fee,

                sum(case type
                        when 'payment' then coalesce(promo_code_partner_amount, 0)
                        else -coalesce(promo_code_partner_refund_amount, 0) end) promo_partner,
                sum(case type
                        when 'payment' then coalesce(promo_code_fee_amount, 0)
                        else -coalesce(promo_code_fee_refund_amount, 0) end)     promo_fee,

                sum(case type
                        when 'payment' then coalesce(plus_fee_amount, 0)
                        else -coalesce(plus_fee_refund_amount, 0) end)           plus_fee,
                sum(case type
                        when 'payment' then coalesce(plus_partner_amount, 0)
                        else -coalesce(plus_partner_refund_amount, 0) end)       plus_partner,

                sum(case type
                        when 'payment' then coalesce(partner_fee_amount, 0)
                        else -coalesce(partner_fee_refund_amount, 0) end)        tech_fee
         from financial_events
              -- filters for manual debug
              --where order_pretty_id = '_YA_PRETTY_ID_'
         group by order_id,
                  order_pretty_id
    ) t
) as t2;
