RECURSE(
    src/test
    src/test-commons
    src/integration
    acceptance
)

JAVA_PROGRAM(orders-app)

# CHECK_JAVA_DEPS(strict)
DIRECT_DEPS_ONLY()

JDK_VERSION(11)
WITH_KOTLIN()

INCLUDE(${ARCADIA_ROOT}/travel/library/java/dependencies.inc)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/lombok.inc)

OWNER(g:travel)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)

EXCLUDE(
    # replaced by org.dom4j
    contrib/java/dom4j/dom4j

    contrib/java/ch/qos/logback/logback-core
    contrib/java/ru/yandex/iceberg-bolts
    contrib/java/ru/yandex/iceberg-misc

)

PEERDIR(
    travel/avia/library/java/booking-providers
    travel/buses/backend/proto
    travel/buses/backend/proto/worker
    travel/hotels/hotels_administrator/proto
    travel/hotels/lib/java/partner_parsers
    travel/hotels/lib/java/commons
    travel/hotels/lib/java/models
    travel/library/java/spring-boot-skeleton
    travel/library/java/jackson-commons
    travel/library/java/ha-grpc-client
    travel/library/java/hibernate-commons
    travel/library/java/workflow
    travel/library/java/workflow_proto
    travel/library/java/logging-ydb
    travel/library/java/takeout
    travel/library/java/balance-client
    travel/library/java/promo-service-booking-flow
    travel/library/java/promo-service-client
    travel/library/java/trust-client
    travel/library/java/yt-lucene-index
    travel/library/java/yt-utils
    travel/notifier/api/order/v1
    travel/orders/proto/common_workflows
    travel/orders/proto/payments
    travel/orders/proto/payments/invoice
    travel/orders/proto/payments/plus
    travel/orders/proto/payments/schedule
    travel/orders/proto/invoice
    travel/orders/proto/order
    travel/orders/proto/order/aeroflot
    travel/orders/proto/order/generic
    travel/orders/proto/order/hotels
    travel/orders/proto/orderitem/aeroflot
    travel/orders/proto/orderitem/aeroflot/mq
    travel/orders/proto/orderitem/bus
    travel/orders/proto/orderitem/bus/ticketrefund
    travel/orders/proto/orderitem/generic
    travel/orders/proto/orderitem/hotels/bnovo
    travel/orders/proto/orderitem/hotels/dolphin
    travel/orders/proto/orderitem/hotels/expedia
    travel/orders/proto/orderitem/hotels/travelline
    travel/orders/proto/orderitem/hotels/bronevik
    travel/orders/proto/orderitem/suburban
    travel/orders/proto/orderitem/train
    travel/orders/proto/orderitem/train/insurancerefund
    travel/orders/proto/orderitem/train/ticketrefund
    travel/orders/proto/services/orders
    travel/orders/proto/services/orders/admin
    travel/orders/proto/services/orders/basic_info/v1
    travel/orders/proto/services/orders/export
    travel/orders/proto/services/orders/cpa
    travel/hotels/proto/extranet_api
    travel/orders/proto/services/orders/idm
    travel/orders/proto/services/orders/yandex_plus
    travel/orders/proto/services/orders/no_auth
    travel/orders/proto/services/orders/user_info
    travel/orders/proto/services/promo
    travel/orders/proto/services/takeout
    travel/orders/proto/trust/refund
    travel/proto/dicts/rasp
    travel/proto/order_type
    travel/proto/white_label
    travel/proto/user_order_counters
    travel/rasp/library/java/bus-parsers
    travel/rasp/library/java/train-parsers
    travel/rasp/library/java/suburban
    travel/rasp/train_bandit_api/proto

    # remove it temporarily to avoid log4j2.xml clashing
    # TODO (mbobrov): reconfigure to use external log4j2.xml config file
    # logbroker/unified_agent/client/java/log4j2

    tracker/tracker-java-client/tracker-client/src/main

    contrib/java/one/util/streamex
    contrib/java/org/springframework/boot/spring-boot-starter-data-jpa
    contrib/java/org/springframework/boot/spring-boot-starter-quartz
    contrib/java/org/springframework/boot/spring-boot-starter-validation
    contrib/java/org/asynchttpclient/async-http-client
    contrib/java/org/apache/logging/log4j/log4j-jcl
    contrib/java/org/flywaydb/flyway-core
    contrib/java/org/javamoney/moneta/moneta-core
    contrib/java/org/javamoney/moneta/moneta-convert
    contrib/java/org/javamoney/moneta/moneta-convert-imf
    contrib/java/org/javamoney/moneta/moneta-convert-ecb
    contrib/java/org/hibernate/hibernate-envers

    # JDK 11 does not javax.xml.bind.* packages
    contrib/java/javax/xml/bind/jaxb-api/2.3.0
    contrib/java/com/sun/xml/bind/jaxb-impl/2.3.0
    contrib/java/com/sun/xml/bind/jaxb-core/2.3.0

    contrib/java/com/h2database/h2
    contrib/java/org/postgresql/postgresql
    contrib/java/net/ttddyy/datasource-proxy/1.5.1

    contrib/java/com/amazonaws/aws-java-sdk-s3
    contrib/java/com/amazonaws/aws-java-sdk-sqs

    contrib/java/org/apache/httpcomponents/httpclient
    contrib/java/org/apache/httpcomponents/httpcore
    contrib/java/javax/mail/mail
    contrib/java/javax/mail/mailapi

    contrib/java/org/jxls/jxls
    contrib/java/org/jxls/jxls-poi
    contrib/java/org/apache/poi/poi
    contrib/java/org/apache/poi/poi-ooxml
    contrib/java/org/apache/poi/poi-ooxml-schemas

    contrib/java/com/netflix/concurrency-limits/concurrency-limits-core

    contrib/libs/grpc/src/proto/grpc/health/v1

    kikimr/persqueue/sdk/java/v0

    contrib/java/org/mockito/kotlin/mockito-kotlin/3.2.0

    contrib/java/org/jetbrains/kotlin/kotlin-reflect
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/travel/hotels/devops/starter/starter.template.py
    OUT ${BINDIR}/bin/orders.py
    CUSTOM_PROPERTY appName orders-app
    CUSTOM_PROPERTY mainClass ru.yandex.travel.orders.OrdersApplication
)

# Added automatically to remove dependency on default contrib versions
DEPENDENCY_MANAGEMENT(
    contrib/java/one/util/streamex/0.7.2
    contrib/java/org/jxls/jxls/2.8.1
    contrib/java/org/jxls/jxls-poi/2.8.1
    contrib/java/org/apache/poi/poi/4.1.2
    contrib/java/org/apache/poi/poi-ooxml/4.1.2
    contrib/java/org/apache/poi/poi-ooxml-schemas/4.1.2
    contrib/java/com/netflix/concurrency-limits/concurrency-limits-core/0.3.6
)

LINT(base)
END()
