------------------------- MODULE ExpediaServiceSpec -------------------------
(* ExpediaServiceSpec animates the model with a simple scheduler
 * and checks invariants and temporal properties.
 *)

EXTENDS ExpediaServiceModel

\* This action enqueues a bit more events into the workflow once its stuck.
UserNext == Len(queue) = 0 /\
  \/ state = "EWS_New"      /\ Enqueue("SE_Reserve")
  \/ state = "EWS_Reserved" /\ Enqueue("SE_Cancel")
  \/ state = "EWS_Reserved" /\ Enqueue("SE_Confirm")

Init == ModelInit

Next ==
  \/ ModelNext
  \/ UserNext

\* The workflow must eventually either consume an outstanding message
\* or receive a message from the user.
Fairness == WF_vars(ModelNext) /\ WF_vars(UserNext)

Spec == Init /\ [][Next]_vars /\ Fairness

-----------------------------------------------------------------------------

TypeInvariant == ModelTypeInvariant

StateInvariants ==
  /\ TypeInvariant

\* If the booking was held, then the workflow must visit the 'Reserved' state.
TemporalReserve ==
  (state = "EWS_Reserving") ~> (
    (state = "EWS_Reserved" /\ remoteExpediaState = "ES_OnHold") \/
    (state = "EWS_Cancelled" /\ E!IsNonexistent))

\* If the workflow was instructed to cancel the booking,
\* it must be able to do so and terminate in the 'Cancelled' state.
TemporalCancel1 ==
  (state = "EWS_Cancelling") ~> [](state = "EWS_Cancelled" /\ E!IsCancelled)

\* Vice versa, if the booking was cancelled,
\* the workflow must eventually learn that.
TemporalCancel2 ==
  (remoteExpediaState = "ES_Expired") ~> [](state = "EWS_Cancelled")

\* If the workflow was instructed to confirm the booking,
\* it must be able to do so or terminate in the 'Cancelled' state.
TemporalConfirm1 ==
  (state = "EWS_Confirming") ~> (
    (state = "EWS_Confirmed" /\ E!IsConfirmed) \/
    (state = "EWS_Cancelled" /\ E!IsCancelled))

\* Vice versa, if the booking was confirmed,
\* the workflow must eventually learn that.
TemporalConfirm2 ==
  (remoteExpediaState = "ES_Confirmed") ~> [](state = "EWS_Confirmed")

TemporalProperties ==
  /\ TemporalReserve
  /\ TemporalCancel1 /\ TemporalCancel2
  /\ TemporalConfirm1 /\ TemporalConfirm2

THEOREM Spec => StateInvariants /\ TemporalProperties

=============================================================================
\* Modification History
\* Last modified Fri Feb 08 15:15:18 MSK 2019 by sandello
\* Created Tue Jan 29 21:25:40 MSK 2019 by sandello

